@php
    $scheduleContent = getContent('schedule.content', true);
    $saturdayData    = App\Models\Event::where('day', 'saturday')->latest()->with('rj')->get();
    $sundayData      = App\Models\Event::where('day', 'sunday')->latest()->with('rj')->get();
    $mondayData      = App\Models\Event::where('day', 'monday')->latest()->with('rj')->get();
    $tuesdayData     = App\Models\Event::where('day', 'tuesday')->latest()->with('rj')->get();
    $wednesdayData   = App\Models\Event::where('day', 'wednesday')->latest()->with('rj')->get();
    $thursdayData    = App\Models\Event::where('day', 'thursday')->latest()->with('rj')->get();
    $fridayData      = App\Models\Event::where('day', 'friday')->latest()->with('rj')->get();
@endphp

<section class="pt-100 pb-100 bg_img overlay--one" style="background-image: url({{ frontendImage('schedule', @$scheduleContent->data_values->background_image,'1920x1280') }});">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section-title text-uppercase">{{ __(@$scheduleContent->data_values->heading) }}</h2>
                    <div class="equalizer">
                        <span class="equalizer-item equalizer-1"></span>
                        <span class="equalizer-item equalizer-2"></span>
                        <span class="equalizer-item equalizer-3"></span>
                        <span class="equalizer-item equalizer-4"></span>
                        <span class="equalizer-item equalizer-5"></span>
                        <span class="equalizer-item equalizer-6"></span>
                    </div>
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col-lg-12">
                <ul class="nav nav-tabs custom--tab mb-5 justify-content-center" id="scheduleTab" role="tablist">
                    <li class="nav-item">
                        <button class="nav-link active day" id="day-1-tab" data-bs-toggle="tab" data-bs-target="#day-1" data-tab="1">@lang('Saturday')</button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link day" id="day-2-tab" data-bs-toggle="tab" data-bs-target="#day-2"
                            type="button" role="tab" aria-controls="day-2" aria-selected="false" data-tab="2">@lang('Sunday')</button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link day" id="day-3-tab" data-bs-toggle="tab" data-bs-target="#day-3"
                            type="button" role="tab" aria-controls="day-3" aria-selected="false" data-tab="3">@lang('Monday')</button>
                    </li>

                    <li class="nav-item">
                        <button class="nav-link day" id="day-4-tab" data-bs-toggle="tab" data-bs-target="#day-4"
                            type="button" role="tab" aria-controls="day-4" aria-selected="false" data-tab="4">@lang('Tuesday')</button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link day" id="day-5-tab" data-bs-toggle="tab" data-bs-target="#day-5"
                            type="button" role="tab" aria-controls="day-5" aria-selected="false" data-tab="5">@lang('Wednesday')</button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link day" id="day-6-tab" data-bs-toggle="tab" data-bs-target="#day-6"
                            type="button" role="tab" aria-controls="day-6" aria-selected="false" data-tab="6">@lang('Thursday')</button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link day" id="day-7-tab" data-bs-toggle="tab" data-bs-target="#day-7"
                            type="button" role="tab" aria-controls="day-7" aria-selected="false" data-tab="7">@lang('Friday')</button>
                    </li>
                </ul>

                <div class="tab-content" id="scheduleTabContent">
                    <div class="tab-pane fade show active" id="day-1" role="tabpanel" aria-labelledby="day-1-tab">
                        <div class="row gy-4 justify-content-center">
                            @forelse ($saturdayData as $saturday)
                                <div class="col-lg-4 col-md-6">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <img src="{{ getImage(getFilePath('event') . '/' . $saturday->image, getFileSize('event')) }}" alt="@lang('image')">

                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($saturday->name) }}</h3>
                                                <p class="time">
                                                    {{ __($saturday->start) }} @lang('to') {{ __($saturday->end) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="rj">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $saturday->rj->image, getFileSize('rj')) }}" alt="@lang('image')">
                                            </div>
                                            <div class="content">
                                                <h5 class="name">{{ __($saturday->rj->name) }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-8 col-md-8">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($emptyMessage) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <div class="tab-pane fade" id="day-2" role="tabpanel" aria-labelledby="day-2-tab">
                        <div class="row gy-4 justify-content-center">
                            @forelse ($sundayData as $sunday)
                                <div class="col-lg-4 col-md-6">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <img src="{{ getImage(getFilePath('event') . '/' . $sunday->image, getFileSize('event')) }}" alt="@lang('image')">

                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($sunday->name) }}</h3>
                                                <p class="time">
                                                    {{ __($sunday->start) }} @lang('to') {{ __($sunday->end) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="rj">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $sunday->rj->image, getFileSize('rj')) }}" alt="@lang('image')">
                                            </div>
                                            <div class="content">
                                                <h5 class="name">{{ __($sunday->rj->name) }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-8 col-md-8">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($emptyMessage) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <div class="tab-pane fade" id="day-3" role="tabpanel" aria-labelledby="day-3-tab">
                        <div class="row gy-4 justify-content-center">
                            @forelse ($mondayData as $monday)
                                <div class="col-lg-4 col-md-6">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <img src="{{ getImage(getFilePath('event') . '/' . $monday->image, getFileSize('event')) }}" alt="@lang('image')">

                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($monday->name) }}</h3>
                                                <p class="time">
                                                    {{ __($monday->start) }} @lang('to') {{ __($monday->end) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="rj">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $monday->rj->image, getFileSize('rj')) }}" alt="@lang('image')">
                                            </div>
                                            <div class="content">
                                                <h5 class="name">{{ __($monday->rj->name) }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-8 col-md-8">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($emptyMessage) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <div class="tab-pane fade" id="day-4" role="tabpanel" aria-labelledby="day-4-tab">
                        <div class="row gy-4 justify-content-center">
                            @forelse ($tuesdayData as $tuesday)
                                <div class="col-lg-4 col-md-6">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <img src="{{ getImage(getFilePath('event') . '/' . $tuesday->image, getFileSize('event')) }}" alt="@lang('image')">

                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($tuesday->name) }}</h3>
                                                <p class="time">
                                                    {{ __($tuesday->start) }} @lang('to') {{ __($tuesday->end) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="rj">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $tuesday->rj->image, getFileSize('rj')) }}" alt="@lang('image')">
                                            </div>
                                            <div class="content">
                                                <h5 class="name">{{ __($tuesday->rj->name) }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-8 col-md-8">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($emptyMessage) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <div class="tab-pane fade" id="day-5" role="tabpanel" aria-labelledby="day-5-tab">
                        <div class="row gy-4 justify-content-center">
                            @forelse ($wednesdayData as $wednesday)
                                <div class="col-lg-4 col-md-6">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <img src="{{ getImage(getFilePath('event') . '/' . $wednesday->image, getFileSize('event')) }}" alt="@lang('image')">

                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($wednesday->name) }}</h3>
                                                <p class="time">
                                                    {{ __($wednesday->start) }} @lang('to') {{ __($wednesday->end) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="rj">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $wednesday->rj->image, getFileSize('rj')) }}" alt="@lang('image')">
                                            </div>
                                            <div class="content">
                                                <h5 class="name">{{ __($wednesday->rj->name) }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-8 col-md-8">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($emptyMessage) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>
                    <div class="tab-pane fade" id="day-6" role="tabpanel" aria-labelledby="day-6-tab">
                        <div class="row gy-4 justify-content-center">
                            @forelse ($thursdayData as $thursday)
                                <div class="col-lg-4 col-md-6">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <img src="{{ getImage(getFilePath('event') . '/' . $thursday->image, getFileSize('event')) }}" alt="@lang('image')">

                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($thursday->name) }}</h3>
                                                <p class="time">
                                                    {{ __($thursday->start) }} @lang('to') {{ __($thursday->end) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="rj">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $thursday->rj->image, getFileSize('rj')) }}" alt="@lang('image')">
                                            </div>
                                            <div class="content">
                                                <h5 class="name">{{ __($thursday->rj->name) }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-8 col-md-8">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($emptyMessage) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <div class="tab-pane fade" id="day-7" role="tabpanel" aria-labelledby="day-7-tab">
                        <div class="row gy-4 justify-content-center">
                            @forelse ($fridayData as $friday)
                                <div class="col-lg-4 col-md-6">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <img src="{{ getImage(getFilePath('event') . '/' . $friday->image, getFileSize('event')) }}" alt="@lang('image')">

                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($friday->name) }}</h3>
                                                <p class="time">
                                                    {{ __($friday->start) }} @lang('to') {{ __($friday->end) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="rj">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $friday->rj->image, getFileSize('rj')) }}" alt="@lang('image')">
                                            </div>
                                            <div class="content">
                                                <h5 class="name">{{ __($friday->rj->name) }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-8 col-md-8">
                                    <div class="schedule-card">
                                        <div class="schedule-card__thumb">
                                            <div class="overlay-content">
                                                <h3 class="schedule-name">{{ __($emptyMessage) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
