@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="pt-100 pb-100 bg_img overlay--one">
        <div class="container">
            <div class="row justify-content-center mb-5">
                <div class="col-lg-12">
                    <div class="profile-wrapper">
                        <div class="row align-items-end">
                            <div class="col-lg-3 col-md-5">
                                <div class="thumb">
                                    <img src="{{ getImage(getFilePath('rj') . '/' . $rj->image, getFileSize('rj')) }}"
                                        alt="@lang('image')">
                                </div>
                            </div>
                            <div class="col-lg-9 col-md-7 ps-md-4 mt-md-0 mt-4">
                                <div class="content">
                                    <h2 class="rj-name">{{ __($rj->name) }}</h4>
                                        <span>{{ __($rj->designation) }}</span>
                                        <ul class="social-links-list mt-3">
                                            @foreach ($rj->socials as $social)
                                                <li><a href="{{ $social->url }}" target="_blank" class="rounded-2">
                                                        @php echo $social->icon; @endphp
                                                    </a></li>
                                            @endforeach
                                        </ul>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-5">
                            <div class="col-lg-12">
                                <h3>@lang('About') {{ __($rj->fullname) }}</h3>
                                <p class="mt-3">{{ __($rj->about) }}</p>
                                <h3 class="mt-5 mb-3">@lang('Educational Experience')</h3>

                                <div class="row gy-4">
                                    @foreach ($rj->education as $education)
                                        <div class="col-lg-6">
                                            <div class="resume-card">
                                                <div class="icon">
                                                    <i class="las la-school"></i>
                                                </div>
                                                <div class="content">
                                                    <span
                                                        class="resume-duration font-size--14px">{{ $education->form_year . ' To ' . $education->to_year }}</span>
                                                    <h5 class="title">{{ __($education->name) }}</h5>
                                                    <p class="mt-3 font-size--14px">{{ __($education->about) }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <h3 class="mt-5 mb-3">@lang('Work Experience')</h3>

                                <div class="row gy-4">
                                    @foreach ($rj->experience as $experience)
                                        <div class="col-lg-6">
                                            <div class="resume-card">
                                                <div class="icon">
                                                    <i class="las la-briefcase"></i>
                                                </div>
                                                <div class="content">
                                                    <span
                                                        class="resume-duration font-size--14px">{{ $experience->form_year . ' To ' . $experience->to_year }}</span>
                                                    <h5 class="title">{{ __($experience->name) }}</h5>
                                                    <p class="mt-3 font-size--14px">{{ __($experience->responsibility) }}
                                                    </p>
                                                </div>
                                            </div><!-- resume-card end -->
                                        </div>
                                    @endforeach
                                </div><!-- row end -->
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- row end -->

            @if ($rj->gallery)
                <h3 class="mb-4">{{ __($rj->name . ' Gallary') }}</h3>

                <div class="row gy-4">
                    @foreach ($rj->gallery as $gallery)
                        {{-- @dd($gallery); --}}
                        <div class="col-lg-4 col-sm-6">
                            <div class="schedule-card">
                                <div class="schedule-card__thumb">
                                    <img src="{{ getImage(getFilePath('gallery') . '/' . $gallery, getFileSize('gallery')) }}"
                                        alt="@lang('image')">
                                    <a href="{{ getImage(getFilePath('gallery') . '/' . $gallery) }}"
                                        class="view-details-btn" data-rel="lightcase:myCollection:slideshow"><i
                                            class="las la-plus"></i></a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </section>
@endsection

@push('style')
    <style>
        [class*='lightcase-icon-']:before {
            font-family: "Line Awesome Free";
            font-weight: 600 !important;
            font-size: 25px;
            border: 1px solid #dddddd29;
            width: 50px;
            height: 50px;
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 50%;
        }

        .lightcase-icon-next:before {
            content: '\f105';
        }

        .lightcase-icon-prev:before {
            content: '\f104';
        }

        .lightcase-icon-close:before {
            content: '\f00d';
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            'use strict'

            $('a[data-rel^=lightcase]').lightcase();
        })(jQuery);
    </script>
@endpush
