@php
    $language = App\Models\Language::all();
    $selectedLang = $language->where('code', session('lang'))->first();
@endphp
<header class="header">
    <div class="header__bottom">
        <div class="container-fluid p-0">
            <nav class="navbar navbar-expand-xl p-0 align-items-center">
                <a class="site-logo site-title" href="{{ route('home') }}">
                    <img src="{{ siteLogo() }}" alt="@lang('site-logo')">
                    <div class="equalizer">
                        <span class="equalizer-item equalizer-1"></span>
                        <span class="equalizer-item equalizer-2"></span>
                        <span class="equalizer-item equalizer-3"></span>
                        <span class="equalizer-item equalizer-4"></span>
                        <span class="equalizer-item equalizer-5"></span>
                        <span class="equalizer-item equalizer-6"></span>
                        <span class="equalizer-item equalizer-7"></span>
                        <span class="equalizer-item equalizer-8"></span>
                        <span class="equalizer-item equalizer-9"></span>
                        <span class="equalizer-item equalizer-10"></span>
                        <span class="equalizer-item equalizer-11"></span>
                        <span class="equalizer-item equalizer-12"></span>
                        <span class="equalizer-item equalizer-none"></span>
                    </div>
                </a>

                <div class="d-flex gap-3 align-items-center">
                    @if (gs()->multi_language)
                    <div class="dropdown-lang dropdown mt-0 d-block d-xl-none">
                        <a href="#" class="language-btn dropdown-toggle" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <img class="flag"
                                src="{{ getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language')) }}"
                                alt="us">
                            <span class="language-text text-white">{{ @$selectedLang->name }}</span>
                        </a>
                        <ul class="dropdown-menu">
                            @foreach ($language as $lang)
                                <li><a href="{{ route('lang', $lang->code) }}"><img class="flag"
                                            src="{{ getImage(getFilePath('language') . '/' . @$lang->image, getFileSize('language')) }}"
                                            alt="@lang('image')">
                                        {{ @$lang->name }}</a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <span class="menu-toggle"></span>
                    </button>
                </div>

                <div class="collapse navbar-collapse mt-lg-0" id="navbarSupportedContent">
                    <ul class="navbar-nav main-menu ms-auto align-items-center">
                        <li><a href="{{ route('home') }}" class="{{ menuActive('home') }}">@lang('Home')</a></li>

                        @foreach ($pages as $k => $data)
                            <li><a href="{{ route('pages', [$data->slug]) }}">{{ __($data->name) }}</a></li>
                        @endforeach

                        <li><a href="{{ route('event.list') }}"
                                class="{{ menuActive('event.list') }}">@lang('Archive Events')</a></li>
                        <li><a href="{{ route('rj.list') }}" class="{{ menuActive('rj.list') }}">@lang('All Rj')</a>
                        </li>
                        <li><a href="{{ route('contact') }}" class="{{ menuActive('contact') }}">@lang('Contact')</a>
                        </li>

                    </ul>

                    @if (gs()->multi_language)
                        <div class="dropdown-lang dropdown mt-0 d-none d-xl-block">
                            <a href="#" class="language-btn dropdown-toggle" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <img class="flag"
                                    src="{{ getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language')) }}"
                                    alt="us">
                                <span class="language-text text-white">{{ @$selectedLang->name }}</span>
                            </a>
                            <ul class="dropdown-menu">
                                @foreach ($language as $lang)
                                    <li><a href="{{ route('lang', $lang->code) }}"><img class="flag"
                                                src="{{ getImage(getFilePath('language') . '/' . @$lang->image, getFileSize('language')) }}"
                                                alt="@lang('image')">
                                            {{ @$lang->name }}</a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>

                    @endif
                </div>
            </nav>
        </div>
    </div>
</header>
