@php
    $footerContent  = getContent('footer.content', true);
    $socialElements = getContent('social_icon.element', false, null, true);
    $policyElements = getContent('policy_pages.element', false, null, true);
@endphp

<footer class="footer bg_img" style="background-image: url({{ frontendImage('footer', @$footerContent->data_values->background_image,'1920x1280') }});">
    <div class="footer__top">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-6 text-center">
            <a href="{{route('home')}}" class="site-logo">
                <img src="{{ siteLogo() }}" alt="@lang('image')">
            </a>
            <p class="mt-3">{{ __(@$footerContent->data_values->sub_heading) }}</p>
            <ul class="social-links-list justify-content-center mt-3">
              @foreach ($socialElements as $social)
                <li>
                  <a href="{{@$social->data_values->url}}"> @php echo @$social->data_values->icon; @endphp </a>
                </li>
              @endforeach
            </ul>
          </div>
        </div>
      </div>
    </div>

    <div class="footer__bottom">
      <div class="container">
        <div class="row">
          <div class="col-lg-5 col-md-6 order-lg-1 order-2 text-md-start text-center">
            <p>@lang('Copyright') © @php echo date('Y') @endphp @lang(' All Right Reserved')</p>
          </div>
          <div class="col-lg-2 text-center order-lg-2 order-1">
            <div class="scroll-to-top">
              <i class="las la-angle-double-up"></i>
            </div>
          </div>
          <div class="col-lg-5 col-md-6 order-lg-3 order-3">
            <ul class="footer-short-list d-flex flex-wrap justify-content-md-end justify-content-center">
              @foreach ($policyElements as $policy)
                <li>
                    <a href="{{ route('policy.pages', $policy->slug) }}">{{ __(@$policy->data_values->title) }}</a>
                </li>
              @endforeach
            </ul>
          </div>
        </div>
      </div>
    </div>
</footer>
