<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ gs()->siteName(__($pageTitle)) }}</title>

    @include('partials.seo')

    <link href="{{ asset('assets/global/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/global/css/all.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/global/css/line-awesome.min.css') }}">

    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/slick.css') }}">

    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/lightcase.css') }}">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/main.css') }}">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/custom.css') }}">
    <link rel="stylesheet"
        href="{{ asset($activeTemplateTrue . 'css/color.php') }}?color={{ gs()->base_color }}&secondColor={{ gs()->secondary_color }}">

    @stack('style-lib')
    @stack('style')
</head>

@php echo loadExtension('google-analytics') @endphp

<body>
    <div class="cursor"></div>
    <div class="cursor-follower"></div>

    <div class="body-overlay"></div>


    <div class="preloader">
        <div class="preloader__inner">
            <div class="logo-area">
                <img src="{{ getImage('assets/images/logo_icon/preloader.png') }}" alt="@lang('image')"
                    class="preloader-img">
                <h3 class="logo-name">{{ __(gs()->site_name) }}</h3>
                <div class="equalizer">
                    <span class="equalizer-item equalizer-1"></span>
                    <span class="equalizer-item equalizer-2"></span>
                    <span class="equalizer-item equalizer-3"></span>
                    <span class="equalizer-item equalizer-4"></span>
                    <span class="equalizer-item equalizer-5"></span>
                    <span class="equalizer-item equalizer-6"></span>
                    <span class="equalizer-item equalizer-7"></span>
                    <span class="equalizer-item equalizer-none"></span>
                </div>
            </div>
            <div class="loading-bar"></div>
        </div>
    </div>

    @include($activeTemplate . 'partials.header')

    <div @if (!request()->routeIs('maintenance')) class="main-wrapper" @endif>
        @if (!request()->routeIs('home') && !request()->routeIs('maintenance'))
            @include($activeTemplate . 'partials.breadcrumb')
        @endif

        @yield('content')
    </div>

    @include($activeTemplate . 'partials.footer')

    @php
        $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
    @endphp

    @if ($cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie'))
        <div class="cookies-card text-center hide">
            <div class="cookies-card__icon bg--base">
                <i class="las la-cookie-bite"></i>
            </div>

            <p class="mt-4 cookies-card__content">{{ $cookie->data_values->short_desc }} <a
                    href="{{ route('cookie.policy') }}" target="_blank">@lang('learn more')</a></p>

            <div class="cookies-card__btn mt-4">
                <button class="btn btn--base w-100 policy">@lang('Allow')</button>
            </div>
        </div>
    @endif

    <script src="{{ asset('assets/global/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/slick.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/wow.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/lightcase.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/jquery.paroller.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/TweenMax.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/app.js') }}"></script>

    @stack('script-lib')
    @stack('script')

    @include('partials.notify')

    <script>
        (function($) {
            @if (request()->routeIs('home'))
                $(window).on("scroll", function() {
                    elementEffectLeft();
                });

                function elementEffectLeft() {
                    var heroSec = document.querySelector('.hero').clientHeight;

                    var element = $(".main-wrapper");
                    if ($(this).scrollTop() > heroSec) {
                        element.addClass("active");
                    } else {
                        element.removeClass("active");
                    }
                }
            @endif

            "use strict";

            $(".langSel").on("change", function() {
                window.location.href = "{{ route('home') }}/change/" + $(this).val();
            });

            $('.policy').on('click', function() {
                $.get('{{ route('cookie.accept') }}', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('[type=text],select,textarea');
            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $.each($('input, select, textarea'), function(i, element) {
                var elementType = $(element);
                if (elementType.attr('type') != 'checkbox') {
                    if (element.hasAttribute('required')) {
                        $(element).closest('.form-group').find('label').addClass('required');
                    }
                }
            });

            let disableSubmission = false;
            $('.disableSubmission').on('submit', function(e) {
                if (disableSubmission) {
                    e.preventDefault()
                } else {
                    disableSubmission = true;
                }
            });

            Array.from(document.querySelectorAll('table')).forEach(table => {
                let heading = table.querySelectorAll('thead tr th');
                Array.from(table.querySelectorAll('tbody tr')).forEach((row) => {
                    Array.from(row.querySelectorAll('td')).forEach((colum, i) => {
                        colum.setAttribute('data-label', heading[i].innerText)
                    });
                });
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });

            var audioPlayer = document.querySelector(".audio-player");
            var audioData = $(".audio-player").attr('data-audio');
            var audio = new Audio(audioData);
            var player = [];

            $(".controls .toggle-play").each(function() {
                $(this).on('click', function() {
                    $('.event_audio').each(function(index) {
                        player[index] = new Audio($(this).data('audio'));
                        if (!player[index].paused) {
                            player[index].pause()
                        }
                    });

                    $(this).parent().parent().parent().toggleClass('active');
                    const el = $(this).parent().parent().parent();

                    if (audio.paused) {
                        $(this).removeClass("play");
                        $(this).addClass("pause");
                        audio.play();
                    } else {
                        $(this).removeClass("pause");
                        $(this).addClass("play");
                        audio.pause();
                    }
                });
            });
        })(jQuery);
    </script>

</body>

</html>
