@extends($activeTemplate.'layouts.frontend')
@section('content')

    @php
        $bannerElements = getContent('banner.element', false, null, true);
    @endphp

    <section class="hero">
        <div class="hero-slider">
            @foreach ($bannerElements as $banner)
                <div class="single-slide bg_img"
                    style="background-image: url({{ frontendImage('banner', @$banner->data_values->background_image,'1920x1280') }});">
                    <div class="container">
                        <div class="row {{ $loop->even ? 'justify-content-end' : '' }}">
                            <div class="col-lg-4 {{ $loop->even ? 'text-end' : '' }}">
                                <h2 class="hero__title" data-animation="fadeInUp" data-delay=".6s">
                                    {{ __(@$banner->data_values->heading) }}</h2>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </section>

    <button type="button" class="poll-open-btn bg--base">@lang('Vote')</button>

    <div class="poll-box">
        <button type="button" class="poll-close-btn bg--base"><i class="las la-times"></i></button>
        <div class="poll-box__header">
            <h5 class="title">{{ __(@$poll->question) }}</h5>
        </div>

        @if (!empty($poll->options))
            <form action="{{ route('poll.vote',$poll??0) }}" method="POST">
                @csrf
                <div class="poll-box__body">
                    @foreach ($poll->options as $key => $option)
                        @php
                            $percent = pollPercent($poll, $option);
                        @endphp

                        <div class="progress poll--progess mb-2">
                            <span class="poll-percentage">{{$percent.'%'}}</span>
                            <div class="form-check custom-radio">
                                <input class="form-check-input" type="radio" name="radioPoll" id="pollYes-{{$loop->iteration}}" value="{{ $key }}">
                                <label class="form-check-label" for="pollYes-{{$loop->iteration}}">
                                    {{ $option }}
                                </label>
                            </div>
                            <div class="progress-bar" role="progressbar" style="width: {{$percent}}%" aria-valuenow="{{$percent}}" aria-valuemin="0"
                                aria-valuemax="100"></div>
                        </div>
                    @endforeach

                    <p>@lang('You Voted : '){{$pollLog}}</p>
                </div>

                @if (!$pollLog)
                    <div class="poll-box__footer text-center">
                        <input type="submit" value="Vote" class="btn btn-sm btn--base px-4">
                    </div>
                @endif
            </form>
        @endif
    </div>

    @if($sections->secs != null)
        @foreach(json_decode($sections->secs) as $sec)
            @include($activeTemplate.'sections.'.$sec)
        @endforeach
    @endif
@endsection

@push('script')
    <script>
        (function ($) {
            'use strict'

            $('.poll-open-btn').on('click', function() {
                $('.poll-box').addClass('active');
            });
            $('.poll-close-btn').on('click', function() {
                $('.poll-box').removeClass('active');
            });
        })(jQuery);
    </script>
@endpush
