@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="pt-100 pb-100 bg_img overlay--two">
        <div class="container">
            <div class="row mb-3 justify-content-end">
                <div class="col-4">
                    <form class="date-select-form">
                        <input type="text" id="datepicker" value="{{ request()->date ?? '' }}" data-format="Y-m-d"
                            name="date" data-language="en" class="form--control hasDatepicker" placeholder="Select Date"
                            autocomplete="off">
                        <button type="submit" class="date-select-btn"><i class="las la-search"></i></button>
                    </form>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                @include($activeTemplate . 'partials.basic_event')
            </div>
        </div>
    </section>
@endsection


@push('script-lib')
    <script src="{{ asset('assets/global/js/datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/datepicker.en.js') }}"></script>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/global/css/datepicker.min.css') }}">
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            $('.hasDatepicker').datepicker({
                maxDate: new Date(),
            });
            $('.hasDatepicker').on('keyup keypress input keydown', function(e) {
                return false;
            });
        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .datepicker {
            background: #0d2f4d;
            color: #cc2e94;
        }

        .datepicker--cell.-disabled- {
            color: #cc2e94;
            opacity: .5;
        }
    </style>
@endpush
