@extends($activeTemplate.'layouts.frontend')
@section('content')
    @php
        $contactContent = getContent('contact_us.content', true);
    @endphp

    <section class="pt-100 pb-100 bg_img overlay--one" style="background-image: url({{ frontendImage('contact_us', @$contactContent->data_values->background_image,'1920x1280') }});">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-10">
                    <div class="contact-wrapper">
                        <div class="row gy-4">
                            <div class="col-lg-4">
                                <div class="contact-item">
                                    <div class="icon">
                                        <i class="las la-phone-volume"></i>
                                    </div>
                                    <div class="content">
                                        <h6 class="caption">@lang('Phone number')</h6>
                                        <p><a href="tel:{{@$contactContent->data_values->contact_no}}">{{@$contactContent->data_values->contact_no}}</a></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="contact-item">
                                    <div class="icon">
                                        <i class="las la-envelope"></i>
                                    </div>
                                    <div class="content">
                                        <h6 class="caption">@lang('Email Address')</h6>
                                        <p><a href="mailto:{{@$contactContent->data_values->email}}">{{@$contactContent->data_values->email}}</a></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="contact-item">
                                    <div class="icon">
                                        <i class="las la-map-marked-alt"></i>
                                    </div>
                                    <div class="content">
                                        <h6 class="caption">@lang('Address')</h6>
                                        <p>{{ __(@$contactContent->data_values->address) }}</p>
                                    </div>
                                </div>
                            </div>
                        </div><!-- row end -->

                        <form class="mt-5 verify-gcaptcha" action="" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6 form-group">
                                    <label>@lang('Name')</label>
                                    <input type="text" name="name" placeholder="@lang('Enter full name')" value="{{old('name')}}" class="form--control" required>
                                </div>
                                <div class="col-lg-6 form-group">
                                    <label>@lang('Email')</label>
                                    <input type="email" name="email" placeholder="@lang('Enter email address')" value="{{old('email')}}" class="form--control" required>
                                </div>
                                <div class="col-lg-12 form-group">
                                    <label>@lang('Subject')</label>
                                    <input type="text" name="subject" placeholder="@lang('Enter subject')" value="{{old('subject')}}" class="form--control" required>
                                </div>
                                <div class="col-lg-12 form-group">
                                    <label>@lang('Message')</label>
                                    <textarea name="message" placeholder="@lang('Message')" class="form--control" required>{{old('message')}}</textarea>
                                </div>
                                <x-captcha />
                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn--base w-100">@lang('Message Now')</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if($sections->secs != null)
        @foreach(json_decode($sections->secs) as $sec)
            @include($activeTemplate.'sections.'.$sec)
        @endforeach
    @endif
@endsection
