@push('breadcrumb-plugins')
    <x-back route="javascript:history.back()" />
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/datepicker.en.js') }}"></script>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/global/css/datepicker.min.css') }}">
@endpush

@push('style')
    <style>
        .removeBtn {
            position: absolute;
            top: 5px;
            right: 5px;
            text-align: center;
            width: 25px;
            height: 25px;
            font-size: 12px;
            border-radius: 50%;
            background-color: #df1c1c;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .removeBtn i {
            margin-right: 0px;
            line-height: 10px;
            margin-left: -1px;
            margin-top: 1px;
        }
    </style>
@endpush

@push('script')
    <script>
        $(function() {
            "use strict";

            @if (request()->routeIs('admin.rj.edit'))
                var educationIndex = '{{ $rjEducationCount }}';
                var experienceIndex = '{{ $rjExperienceCount }}';
            @else
                var educationIndex = $(".education-div").find('.div-to-remove').length;
                var experienceIndex = $(".experience-div").find('.div-to-remove').length;
            @endif

            callDatePicker();

            $('.new-education').on('click', function() {
                $('.education-div').append(`<div class="col-md-6 div-to-remove">
                                                <div class="card border--primary mt-3">
                                                    <div class="d-flex flex-wrap justify-content-between bg--primary">
                                                        <h5 class="card-header bg--primary">@lang('Academic Information')</h5>
                                                        <button type="button" class="btn btn--danger text-white border--rounded btn-sm removeBtn">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    </div>
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('Institution Name')</label>
                                                                    <input type="text" class="form-control" name="education[${parseInt(educationIndex)}][name]" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('From Year')</label>
                                                                    <input name="education[${parseInt(educationIndex)}][form_year]" type="search" class="only-year-2 form-control bg--white pe-2" placeholder="@lang('Select Year')" autocomplete="off" required >
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('To Year')</label>
                                                                    <input name="education[${parseInt(educationIndex)}][to_year]" type="search" class="only-year-2 form-control bg--white pe-2" placeholder="@lang('Select Year')" autocomplete="off" required >
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label>@lang('About Institution')</label>
                                                                    <textarea name="education[${parseInt(educationIndex)}][about]" rows="5" required></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>`);
                callDatePicker(`only-year-2`);
                educationIndex++;
            });

            $('.new-experience').on('click', function() {
                $('.experience-div').append(`<div class="col-md-6 div-to-remove">
                                                <div class="card border--primary mt-3">
                                                    <div class="d-flex flex-wrap justify-content-between bg--primary">
                                                        <h5 class="card-header bg--primary">@lang('Experience Information')</h5>
                                                        <button type="button" class="btn btn--danger text-white border--rounded btn-sm removeBtn">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    </div>
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('Company Name')</label>
                                                                    <input type="text" class="form-control" name="experience[${parseInt(experienceIndex)}][name]" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('From Year')</label>
                                                                    <input name="experience[${parseInt(experienceIndex)}][form_year]" type="search" class="only-year-2 form-control bg--white pe-2" placeholder="@lang('Select Year')" autocomplete="off" required >
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('To Year')</label>
                                                                    <input name="experience[${parseInt(experienceIndex)}][to_year]" type="search" class="only-year-2 form-control bg--white pe-2" placeholder="@lang('Select Year')" autocomplete="off" required >
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label>@lang('Job Responsibility')</label>
                                                                    <textarea name="experience[${parseInt(experienceIndex)}][responsibility]" rows="5" required></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>`);
                callDatePicker(`only-year-2`);
                experienceIndex++;
            });

            $(document).on('click', '.removeBtn', function() {
                $(this).closest('.div-to-remove').remove();
            });

            function callDatePicker($classame = 'only-year') {
                $(document).find(`.${$classame}`).datepicker({
                    view: 'years',
                    minView: 'years',
                    dateFormat: 'yyyy',
                    autoClose: true,
                    maxDate: new Date()
                });
            };

            var fileAdded = 0;

            $('.new-gallery').on('click', function() {
                if (fileAdded >= 4) {
                    notify('error', 'You\'ve added maximum number of file');
                    return false;
                }

                fileAdded++;

                $('.gallery-div').append(`<div class="col-md-6 div-to-remove">
                                                <div class="row">
                                                    <div class="col-11 mb-3">
                                                        <div class="file-upload-wrapper" data-text="@lang('Select your file!')"><input type="file" name="gallery[]" id="inputAttachments" class="file-upload-field"/></div>
                                                    </div>
                                                    <div class="col-1">
                                                        <button type="button" class="btn btn--danger removeFile"><i class="la la-times ms-0"></i></button>
                                                    </div>
                                                </div>
                                            </div>`);
            });

            $(document).on('click', '.removeFile', function() {
                fileAdded--;
                $(this).closest('.div-to-remove').remove();
            });
        });
    </script>
@endpush
