@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card mb-4">
                <form action="{{ route('admin.rj.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xxl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Image')</label>
                                    <x-image-uploader class="w-100" type="rj" :required=false />
                                </div>
                            </div>
                            <div class="col-xl-8 col-lg-8 col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Name')</label>
                                            <input class="form-control" type="text" name="name"
                                                value="{{ old('name') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Designation')</label>
                                            <input class="form-control" type="text" name="designation"
                                                value="{{ old('designation') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Email')</label>
                                            <input class="form-control" type="email" name="email"
                                                value="{{ old('email') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Contact No')</label>
                                            <input class="form-control" type="number" name="contact_no"
                                                value="{{ old('contact_no') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang('About Rj')</label>
                                            <textarea name="about" rows="9" required>{{ old('about') }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-12 border-line-area mt-3">
                                <h5 class="card-title border-bottom pb-2 text-center">@lang('Educational Experience')</h5>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12">
                                <div class="text-end">
                                    <button class="btn btn-sm btn--primary new-education" type="button">
                                        <i class="las la-plus"></i>@lang('Add New')
                                    </button>
                                </div>

                                <div class="row education-div">
                                    @if (old('education'))
                                        @foreach (old('education') as $education)
                                            <div class="col-md-6 div-to-remove">
                                                <div class="card border--primary mt-3">
                                                    <h5 class="card-header text-white bg--primary">@lang('Academic Information')</h5>
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('Institution Name')</label>
                                                                    <input type="text" class="form-control"
                                                                        name="education[{{ @$loop->index }}][name]" required
                                                                        value="{{ @$education['name'] }}">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('From Year')</label>
                                                                    <input name="education[{{ @$loop->index }}][form_year]"
                                                                        type="text"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off" required
                                                                        value="{{ @$education['form_year'] }}" readonly>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('To Year')</label>
                                                                    <input name="education[{{ @$loop->index }}][to_year]"
                                                                        type="text"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off" required
                                                                        value="{{ @$education['to_year'] }}" readonly>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label>@lang('About Institution')</label>
                                                                    <textarea name="education[{{ $loop->index }}][about]" rows="5" required>{{ @$education['about'] }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="col-md-6 div-to-remove">
                                            <div class="card border--primary mt-3">
                                                <h5 class="card-header text-white bg--primary">@lang('Academic Information')</h5>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>@lang('Institution Name')</label>
                                                                <input type="text" class="form-control"
                                                                    name="education[0][name]" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>@lang('From Year')</label>
                                                                <input name="education[0][form_year]" type="text"
                                                                    class="only-year form-control bg--white pe-2"
                                                                    autocomplete="off" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>@lang('To Year')</label>
                                                                <input name="education[0][to_year]" type="text"
                                                                    class="only-year form-control bg--white pe-2"
                                                                    autocomplete="off" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>@lang('About Institution')</label>
                                                                <textarea name="education[0][about]" rows="5" required></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                </div>
                            </div>

                            <div class="form-group col-md-12 border-line-area mt-3">
                                <h5 class="card-title border-bottom pb-2 text-center">@lang('Working Experience')</h5>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12">
                                <div class="text-end">
                                    <button class="btn btn-sm btn--primary new-experience" type="button">
                                        <i class="las la-plus"></i>@lang('Add New')
                                    </button>
                                </div>
                                <div class="row experience-div">
                                    @if (old('experience'))
                                        @foreach (old('experience') as $experience)
                                            <div class="col-md-6 div-to-remove">
                                                <div class="card border--primary mt-3">
                                                    <h5 class="card-header text-white bg--primary">@lang('Experience Information')</h5>
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('Company Name')</label>
                                                                    <input type="text" class="form-control"
                                                                        name="experience[{{ @$loop->index }}][name]"
                                                                        value="{{ @$experience['name'] }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('From Year')</label>
                                                                    <input
                                                                        name="experience[{{ @$loop->index }}][form_year]"
                                                                        value="{{ @$experience['form_year'] }}"
                                                                        type="text"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('To Year')</label>
                                                                    <input name="experience[{{ @$loop->index }}][to_year]"
                                                                        value="{{ @$experience['to_year'] }}"
                                                                        type="text"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label>@lang('Job Responsibility')</label>
                                                                    <textarea name="experience[{{ @$loop->index }}][responsibility]" rows="5" required>{{ @$experience['responsibility'] }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="col-md-6 div-to-remove">
                                            <div class="card border--primary mt-3">
                                                <h5 class="card-header text-white bg--primary">@lang('Experience Information')</h5>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>@lang('Company Name')</label>
                                                                <input type="text" class="form-control"
                                                                    name="experience[0][name]" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>@lang('From Year')</label>
                                                                <input name="experience[0][form_year]" type="text"
                                                                    class="only-year form-control bg--white pe-2"
                                                                    autocomplete="off" required readonly>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>@lang('To Year')</label>
                                                                <input name="experience[0][to_year]" type="text"
                                                                    class="only-year form-control bg--white pe-2"
                                                                    autocomplete="off" required readonly>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>@lang('Job Responsibility')</label>
                                                                <textarea name="experience[0][responsibility]" rows="5" required></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                </div>
                            </div>
                            <div class="form-group col-md-12 border-line-area mt-3">
                                <h5 class="card-title border-bottom pb-2 text-center">@lang('Gallery')</h5>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card border--primary mt-3">
                                        <div
                                            class="d-flex flex-wrap justify-content-between align-items-center bg--primary p-1">
                                            <h5 class="card-header bg--primary">@lang('Add More Image')</h5>
                                            <button class="btn btn-sm btn-outline-light new-gallery " type="button">
                                                <i class="las la-plus"></i>@lang('Add New')
                                            </button>
                                        </div>
                                        <div class="row gallery-div p-3">
                                            <div class="form-group">
                                                <label for="inputAttachments">@lang('Image Attachments'), </label> <span
                                                    class="text--danger">@lang('Max 4 files can be uploaded. Maximum upload size is')
                                                    {{ ini_get('upload_max_filesize') }}.</span> @lang('Allowed File Extensions'):
                                                .@lang('jpg'), .@lang('jpeg'), .@lang('png')
                                                @lang('and image will be resized into') <b>{{ getFileSize('gallery') }}</b> @lang('px')
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-12 mt-4">
                                <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@include('admin.rj.script')
