@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card mb-4">
                <form action="{{ route('admin.rj.store', $rj->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xxl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Image')</label>
                                    <x-image-uploader image="{{ $rj->image }}" class="w-100" type="rj"
                                        :required=false />
                                </div>
                            </div>

                            <div class="col-xl-8 col-lg-8 col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Name')</label>
                                            <input class="form-control" type="text" name="name"
                                                value="{{ $rj->name }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Designation')</label>
                                            <input class="form-control" type="text" name="designation"
                                                value="{{ $rj->designation }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Email')</label>
                                            <input class="form-control" type="email" name="email"
                                                value="{{ $rj->email }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>@lang('Contact No')</label>
                                            <input class="form-control" type="number" name="contact_no"
                                                value="{{ $rj->contact_no }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang('About Rj')</label>
                                            <textarea name="about" rows="9" required>{{ $rj->about }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-12 border-line-area mt-3">
                                <h5 class="card-title border-bottom pb-2 text-center">@lang('Educational Experience')</h5>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12">
                                <div class="text-end">
                                    <button class="btn btn-sm btn--primary new-education" type="button">
                                        <i class="las la-plus"></i>@lang('Add New')
                                    </button>
                                </div>

                                <div class="row education-div">
                                    @if ($rj->education)
                                        @foreach ($rj->education as $education)
                                            <div class="col-md-6 div-to-remove">
                                                <div class="card border--primary mt-3">
                                                    <div class="d-flex flex-wrap justify-content-between bg--primary">
                                                        <h5 class="card-header bg--primary">@lang('Academic Information')</h5>

                                                        @if (!$loop->first)
                                                            <button type="button"
                                                                class="btn btn--danger text-white border--rounded btn-sm removeBtn">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        @endif
                                                    </div>

                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('Institution Name')</label>
                                                                    <input type="text" class="form-control"
                                                                        name="education[{{ $loop->index }}][name]"
                                                                        value="{{ $education->name }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('From Year')</label>
                                                                    <input name="education[{{ $loop->index }}][form_year]"
                                                                        type="search"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off"
                                                                        value="{{ $education->form_year }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('To Year')</label>
                                                                    <input name="education[{{ $loop->index }}][to_year]"
                                                                        type="search"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off"
                                                                        value="{{ $education->to_year }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label>@lang('About Institution')</label>
                                                                    <textarea name="education[{{ $loop->index }}][about]" rows="5" required>{{ $education->about }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                            </div>

                            <div class="form-group col-md-12 border-line-area mt-3">
                                <h5 class="card-title border-bottom pb-2 text-center">@lang('Working Experience')</h5>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12">
                                <div class="text-end">
                                    <button class="btn btn-sm btn--primary new-experience" type="button">
                                        <i class="las la-plus"></i>@lang('Add New')
                                    </button>
                                </div>

                                <div class="row experience-div">
                                    @if ($rj->experience)
                                        @foreach ($rj->experience as $experience)
                                            <div class="col-md-6 div-to-remove">
                                                <div class="card border--primary mt-3">
                                                    <div class="d-flex flex-wrap justify-content-between bg--primary">
                                                        <h5 class="card-header bg--primary">@lang('Experience Information')</h5>

                                                        @if (!$loop->first)
                                                            <button type="button"
                                                                class="btn btn--danger text-white border--rounded btn-sm removeBtn">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        @endif
                                                    </div>

                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('Company Name')</label>
                                                                    <input type="text" class="form-control"
                                                                        name="experience[{{ $loop->index }}][name]"
                                                                        value="{{ $experience->name }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('From Year')</label>
                                                                    <input
                                                                        name="experience[{{ $loop->index }}][form_year]"
                                                                        type="search"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off"
                                                                        value="{{ $experience->form_year }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label>@lang('To Year')</label>
                                                                    <input name="experience[{{ $loop->index }}][to_year]"
                                                                        type="search"
                                                                        class="only-year form-control bg--white pe-2"
                                                                        autocomplete="off"
                                                                        value="{{ $experience->to_year }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label>@lang('Job Responsibility')</label>
                                                                    <textarea name="experience[{{ $loop->index }}][responsibility]" rows="5" required>{{ $experience->responsibility }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                            </div>

                            <div class="form-group col-md-12 border-line-area mt-3">
                                <h5 class="card-title border-bottom pb-2 text-center">@lang('Gallery')</h5>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12">
                                @if ($rj->gallery)
                                    <div class="row">
                                        @foreach ($rj->gallery as $gallery)
                                            <div class="col-xl-3 col-lg-3 col-md-6">
                                                <div class="form-group">
                                                    <div class="image-upload">
                                                        <div class="thumb">
                                                            <div class="avatar-preview">
                                                                <div class="profilePicPreview"
                                                                    style="background-image: url({{ getImage(getFilePath('gallery') . '/' . $gallery, getFileSize('gallery')) }})">
                                                                    <button type="button"
                                                                        class="remove-gallery-image remove-img-2 confirmationBtn"
                                                                        type="button" data-question="@lang('Are you sure to remove this image?')"
                                                                        data-action="{{ route('admin.rj.gallery.remove', [$rj->id, $gallery]) }}">
                                                                        <i class="fa fa-times"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="card border--primary mt-3">
                                            <div
                                                class="d-flex flex-wrap justify-content-between align-items-center bg--primary p-1">
                                                <h5 class="card-header bg--primary">@lang('Add More Image')</h5>
                                                <button class="btn btn-sm btn-outline-light new-gallery " type="button">
                                                    <i class="las la-plus"></i>@lang('Add New')
                                                </button>
                                            </div>
                                            <div class="row gallery-div p-3">
                                                <div class="form-group">
                                                    <label for="inputAttachments">@lang('Image Attachments'), </label> <span
                                                        class="text--danger">@lang('Max 4 files can be uploaded. Maximum upload size is')
                                                        {{ ini_get('upload_max_filesize') }}.</span> @lang('Allowed File Extensions'):
                                                    .@lang('jpg'), .@lang('jpeg'), .@lang('png')
                                                    @lang('and image will be resized into') <b>{{ getFileSize('gallery') }}</b>
                                                    @lang('px')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 mt-4">
                                    <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@include('admin.rj.script')

@push('style')
    <style>
        .remove-img-2 {
            position: absolute;
            top: 0;
            right: 0;
            width: 50px;
            height: 50px;
            line-height: 50px;
            text-align: center;
            background: red;
            color: #fff;
            font-size: 18px;
            border-radius: 50% 0 50% 50%;
        }
    </style>
@endpush
