@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Question')</th>
                                    <th>@lang('Options')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                                @forelse($polls as $poll)
                                    <tr>
                                        <td> {{__($poll->question)}} </td>
                                        <td>
                                            @foreach ($poll->options as $option)
                                                <span class="badge badge--primary">{{ __($option) }}</span>
                                            @endforeach
                                        </td>
                                        <td> @php echo $poll->statusBadge @endphp </td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn editBtn" data-resource="{{ $poll }}" data-modal_title="@lang('Edit Poll')" data-has_status="1">
                                                <i class="la la-pencil"></i>@lang('Edit')
                                            </button>
                                            @if ($poll->status == Status::DISABLE)
                                                <button type="button" class="btn btn-sm btn-outline--success confirmationBtn" data-action="{{ route('admin.poll.change.status', $poll->id) }}" data-question="@lang('Are you sure to enable this poll')?">
                                                    <i class="la la-eye"></i>@lang('Enable')
                                                </button>
                                            @else
                                                <button type="button" class="btn btn-sm btn-outline--danger  confirmationBtn" data-action="{{ route('admin.poll.change.status', $poll->id) }}" data-question="@lang('Are you sure to disable this poll')?">
                                                    <i class="la la-eye-slash"></i> @lang('Disable')
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                @if ($polls->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($polls) }}
                    </div>
                @endif

            </div>
        </div>
    </div>

    {{-- Create or Update Modal --}}
    <div id="cuModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.poll.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Question')</label>
                            <input type="text" class="form-control" name="question" value="{{ old('question') }}" required >
                        </div>
                        <div class="form-group">
                            <label>@lang('Options')</label>
                            <select class="select2-auto-tokenize options" name="options[]" multiple='multiple' required></select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<x-confirmation-modal/>

@endsection

@push('breadcrumb-plugins')
    <div class="d-flex justify-content-end align-items-center flex-wrap gap-2">
        <x-search-form placeholder="By Question" />
        <button type="button" class="btn btn-sm btn-outline--primary me-2 h-45 cuModalBtn" data-modal_title="@lang('Add New Poll')">
            <i class="las la-plus"></i>@lang('Add New')
        </button>
    </div>
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/cu-modal.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            $('.editBtn').on('click', function() {
                var resource = $(this).data('resource');
                var option;
                for (let i = 0; i < resource.options.length; i++) {
                    option += "<option selected>" + resource.options[i] + "</option>"
                }

                $('#cuModal').find('select').html(option);
            });

            $('#cuModal').on('hidden.bs.modal', function() {
                $('#cuModal').find('.options').empty();

                $('#cuModal').find('.options').val('').select2({
                    tags: true,
                    tokenSeparators: [',']
                });
            });
        })(jQuery);
    </script>
@endpush

