<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--md  table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Name')</th>
                                <th>@lang('Email')</th>
                                <th>@lang('Phone')</th>
                                <th>@lang('Joined At')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($rjs as $rj)
                                <tr>
                                    <td>
                                        <div class="user">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('rj') . '/' . $rj->image, getFileSize('rj')) }}"
                                                    alt="@lang('image')">
                                                <span>{{ strLimit(__($rj->name), 25) }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td> {{ strLimit($rj->email, 25) }} </td>
                                    <td> {{ strLimit($rj->contact_no, 25) }} </td>
                                    <td> {{ showDateTime($rj->created_at) }} </td>
                                    <td>
                                        <a href="{{ route('admin.rj.social.index', $rj->id) }}"
                                            class="btn btn-sm btn-outline--info">
                                            <i class="las la-share-alt"></i>@lang('Social Icons')
                                        </a>
                                        <a href="{{ route('admin.rj.edit', $rj->id) }}"
                                            class="btn btn-sm btn-outline--primary">
                                            <i class="las la-pencil-alt"></i>@lang('Edit')
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($paginate)
                @if ($rjs->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($rjs) }}
                    </div>
                @endif
            @endif
        </div>
    </div>
</div>
