<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--md  table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Event Name')</th>
                                <th>@lang('Rj')</th>
                                <th>@lang('Day')</th>
                                <th>@lang('Start')</th>
                                <th>@lang('End')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>

                        <tbody>
                            @forelse($events as $event)
                                <tr>
                                    <td>
                                        <div class="user">
                                            <div class="thumb">
                                                <img
                                                    src="{{ getImage(getFilePath('event') . '/' . $event->image, getFileSize('event')) }}">
                                                <span>{{ strLimit(__($event->name), 25) }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <a
                                            href="{{ route('admin.rj.edit', $event->rj->id) }}"><span></span>{{ strLimit(__($event->rj->name), 25) }}</a>
                                    </td>
                                    <td>
                                        @php echo $event->weekDay @endphp
                                    </td>
                                    <td> {{ showDateTime($event->start, 'H:i') }} </td>
                                    <td> {{ showDateTime($event->end, 'H:i') }} </td>
                                    <td>
                                        @php
                                            $event->image_with_path = getImage(
                                                getFilePath('event') . '/' . $event->image,
                                                getFileSize('event'),
                                            );
                                        @endphp
                                        <button type="button"
                                            class="btn btn-sm btn-outline--primary cuModalBtn editBtn"
                                            data-resource="{{ $event }}" data-modal_title="@lang('Edit Event')">
                                            <i class="la la-pencil"></i>@lang('Edit')
                                        </button>
                                        <button type="button" class="btn btn-sm btn-outline--danger confirmationBtn"
                                            data-action="{{ route('admin.event.delete', $event->id) }}"
                                            data-question="@lang('Are you sure to delete this event?')">
                                            <i class="las la-trash"></i>@lang('Delete')
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if ($paginate)
                @if ($events->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($events) }}
                    </div>
                @endif
            @endif

        </div>
    </div>
</div>

{{-- Create or Update Modal --}}
<div id="cuModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="{{ route('admin.event.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>@lang('Image')</label>
                                <x-image-uploader image="" class="w-100" type="event" :required=false />
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>@lang('Radio Jockey')</label>
                                {{-- @dump($rjs) --}}
                                <select name="rj_id" class="form-control select2" required>
                                    <option value="">@lang('Select One')</option>
                                    @foreach ($rjs as $rj)
                                        <option value="{{ $rj->id }}">{{ __($rj->name) }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>@lang('Name')</label>
                                <input type="text" class="form-control" name="name"
                                    placeholder="@lang('Event Name')" value="{{ old('name') }}" required>
                            </div>
                            <div class="form-group">
                                <label>@lang('Week Day')</label>
                                <select name="day" class="form-control select2 select2-day"
                                    data-minimum-results-for-search="-1" required>
                                    <option value="">@lang('Select One')</option>
                                    <option value="saturday">@lang('Saturday')</option>
                                    <option value="sunday">@lang('Sunday')</option>
                                    <option value="monday">@lang('Monday')</option>
                                    <option value="tuesday">@lang('Tuesday')</option>
                                    <option value="wednesday">@lang('Wednesday')</option>
                                    <option value="thursday">@lang('Thursday')</option>
                                    <option value="friday">@lang('Friday')</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>@lang('Start Time')</label>
                                <input type="text" name="start" class="form-control clockpicker"
                                    placeholder="@lang('09:30')" autocomplete="off" required>
                            </div>
                            <div class="form-group ">
                                <label>@lang('End Time')</label>
                                <input type="text" name="end" class="form-control clockpicker"
                                    placeholder="@lang('10:30')" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>



<x-confirmation-modal />



@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/global/css/datepicker.min.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/cu-modal.js') }}"></script>
    <script src="{{ asset('assets/global/js/datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/datepicker.en.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.editBtn').on('click', function() {
                var resource = $(this).data('resource');

                $('#cuModal').find('[name=image]').removeAttr('required');
                $('#cuModal').find('[name=image]').closest('.form-group').find('label').first().removeClass(
                    'required');

                $('.select2').val(resource.rj_id).trigger('change');
                $('.select2-day').val(resource.day).trigger('change');
            });

            var placeHolderImage = "{{ getImage(getFilePath('event'), getFileSize('event')) }}";

            $('#cuModal').on('hidden.bs.modal', function() {
                $('#cuModal').find('.profilePicPreview').css({
                    'background-image': `url(${placeHolderImage})`
                });

                $('#cuModal').find('[name=image]').attr('required', 'required');
                $('#cuModal').find('[name=image]').closest('.form-group').find('label').first().addClass(
                    'required');
            });

            $('.clockpicker').datepicker({
                timepicker: true,
                classes: 'only-timepicker',
                onlyTimepicker: true
            });
        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .datepickers-container {
            z-index: 99999;
        }
    </style>
@endpush
