@extends('admin.layouts.app')

@section('panel')
    <div class="row gy-4">

        <div class="col-xxl-3 col-sm-6">

            <x-widget style="6" link="{{ route('admin.rj.index') }}" icon="las la-headphones-alt" title="Total Rj"
                value="{{ $widget['totalRj'] }}" bg="primary" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget style="6" link="{{ route('admin.event.index') }}" icon="las la-calendar" title="Total Events"
                value="{{ $widget['totalEvent'] }}" bg="success" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget style="6" link="{{ route('admin.archive.index') }}" icon="lar la-file-archive"
                title="Total Archives" value="{{ $widget['totalArchive'] }}" bg="danger" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget style="6" link="{{ route('admin.archive.pending') }}" icon="las la-file-archive"
                title="Pending Archives" value="{{ $widget['totalPendingArchive'] }}" bg="warning" />
        </div><!-- dashboard-w1 end -->
    </div><!-- row end-->

    <div class="mt-4">
        <h4 class="mb-4">@lang('Latest Events')</h4>
        @include('admin.partials.basic_event', ['paginate' => false])
    </div>

    <div class="mt-4">
        <h4 class="mb-4">@lang('Latest Radio Jockeys')</h4>
        @include('admin.partials.basic_rj', ['paginate' => false])
    </div>


    @include('admin.partials.cron_modal')
@endsection
@push('breadcrumb-plugins')
    <button class="btn btn-outline--primary btn-sm" data-bs-toggle="modal" data-bs-target="#cronModal">
        <i class="las la-server"></i>@lang('Cron Setup')
    </button>
@endpush
