@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Event Name')</th>
                                    <th>@lang('Rj')</th>
                                    <th>@lang('Day')</th>
                                    <th>@lang('Start')</th>
                                    <th>@lang('End')</th>
                                    <th>@lang('Type')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>

                            <tbody>
                                @forelse($archives as $archive)
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb">
                                                    <img src="{{ getImage(getFilePath('event') . '/' . $archive->image, getFileSize('event')) }}"
                                                        alt="@lang('image')">
                                                    <span>{{ strLimit(__($archive->name), 25) }}</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <a
                                                href="{{ route('admin.rj.edit', $archive->rj->id) }}"><span></span>{{ strLimit(__($archive->rj->name), 25) }}</a>
                                        </td>
                                        <td>
                                            @php echo $archive->weekDay @endphp
                                        </td>
                                        <td> {{ showDateTime($archive->start, 'H:i') }} </td>
                                        <td> {{ showDateTime($archive->end, 'H:i') }} </td>
                                        <td>
                                            @if ($archive->url)
                                                <span class="badge badge--primary">@lang('Url')</span>
                                            @elseif ($archive->file)
                                                <span class="badge badge--info">@lang('File')</span>
                                            @else
                                                <span class="badge badge--warning">@lang('Nothing yet')</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                $archive->image_with_path = getImage(
                                                    getFilePath('event') . '/' . $archive->image,
                                                    getFileSize('event'),
                                                );
                                            @endphp

                                            <button type="button"
                                                class="btn btn-sm btn-outline--primary cuModalBtn editBtn"
                                                data-resource="{{ $archive }}" data-modal_title="@lang('Edit Archive')"
                                                data-rj="{{ __($archive->rj->name) }}">
                                                <i class="la la-pencil"></i>@lang('Edit')
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline--danger confirmationBtn"
                                                data-action="{{ route('admin.archive.delete', $archive->id) }}"
                                                data-question="@lang('Are you sure to delete this archive?')">
                                                <i class="las la-trash"></i>@lang('Delete')
                                            </button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                @if ($archives->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($archives) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- Create or Update Modal --}}
    <div id="cuModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.archive.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>@lang('Image')</label>
                                    <x-image-uploader image="" class="w-100" type="event" :required=false />
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">
                                    <div class="form-group">
                                        <label>@lang('Radio Jockey')</label>
                                        <input type="text" class="form-control rj" readonly>
                                    </div>
                                    <div class="form-group">
                                        <label>@lang('Name')</label>
                                        <input type="text" class="form-control" name="name" disabled>
                                    </div>
                                    <div class="form-group">
                                        <label>@lang('Week Day')</label>
                                        <select name="day" class="form-control" disabled>
                                            <option value="">@lang('Select One')</option>
                                            <option value="saturday">@lang('Saturday')</option>
                                            <option value="sunday">@lang('Sunday')</option>
                                            <option value="monday">@lang('Monday')</option>
                                            <option value="tuesday">@lang('Tuesday')</option>
                                            <option value="wednesday">@lang('Wednesday')</option>
                                            <option value="thursday">@lang('Thursday')</option>
                                            <option value="friday">@lang('Friday')</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-6">
                                        <label>@lang('Start Time')</label>
                                        <input type="text" name="start" class="form-control" disabled>
                                    </div>
                                    <div class="form-group col-6">
                                        <label>@lang('End Time')</label>
                                        <input type="text" name="end" class="form-control" disabled>
                                    </div>
                                    <div class="form-group d-flex flex-wrap">
                                        <label class="w-100">@lang('File/Url')</label>
                                        <div class="form-group d-flex me-4">
                                            <input type="radio" name="type" id="url" class="url">
                                            <label for="url"
                                                class="d-block align-self-center m-0">@lang('Url')</label>
                                        </div>
                                        <div class="form-group d-flex">
                                            <input type="radio" name="type" id="file" class="file">
                                            <label for="file"
                                                class="d-block align-self-center m-0">@lang('File')</label>
                                        </div>
                                    </div>
                                    <div class="form-group url-file-div">

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <div class="d-flex justify-content-end align-items-center flex-wrap gap-2">
        <x-search-form placeholder="Event Name / Rj Email" />
    </div>
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/cu-modal.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            var urlHtml = `<input type="url" name="url" class="form-control" required>
                            <div class="form-group">
                                <small>@lang('Enter valid url')</small>
                            </div>`;

            var fileHtml = `<input type="file" name="file" accept=".mp3, .mpga, .wav, .ogg" class="form-control" required>
                            <div class="form-group">
                                <small>@lang('Supported files'): <b>@lang('mp3'), @lang('mpga'), @lang('wav'), @lang('ogg').</b></small>
                            </div>`;

            $('#url').on('click', function() {
                $('#cuModal').find('.url-file-div').html(urlHtml);
            });

            $('#file').on('click', function() {
                $('#cuModal').find('.url-file-div').html(fileHtml);
            });


            $('.editBtn').on('click', function() {
                $('#url').click();
                $('#url').attr('checked', true);
                $('#file').attr('checked', false);

                $('input[name="url"]').val('');

                var rj = $(this).data('rj');
                var resource = $(this).data('resource');

                setTimeout(() => {
                    $('#cuModal').find('.rj').val(rj);
                });

                if (resource.url) {
                    $('#cuModal').find('.url-file-div').html(`<input type="url" name="url" class="form-control" value="${resource.url}" required>
                    <div class="form-group">
                        <small>@lang('Enter valid url')</small>
                        </div>`);

                    $('#file').attr('checked', false);
                    $('#url').attr('checked', true);
                }


                if (resource.file) {

                    let url = '{{ asset(getFilePath('archive_file')) . '/' }}' + resource.file;
                    $('#cuModal').find('.url-file-div').html(`
                    <div> <a href="${url}" class="btn btn-primary w-100 mb-2" target="_blank">@lang('Download File')</a> </div>
                    <input type="file" name="file" accept=".mp3, .mpga, .wav, .ogg" class="form-control" required>
                                                                <div class="form-group">
                                                                    <small>@lang('Supported files'): <b>@lang('mp3'), @lang('mpga'), @lang('wav'), @lang('ogg').</b></small>
                                                                </div>`);

                    $('#url').attr('checked', false);
                    $('#file').attr('checked', true);
                }
            });


        })(jQuery);
    </script>
@endpush
