<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Poll;
use Illuminate\Http\Request;

class ManagePollController extends Controller
{
    public function index()
    {
        $pageTitle = 'Poll List';
        $polls     = Poll::searchable(['question'])->latest()->paginate(getPaginate());
        return view('admin.poll', compact('pageTitle', 'polls'));
    }

    public function store(Request $request, $id = 0)
    {
        $request->validate([
            'question' => 'required|max:255',
            'options'  => 'required|array|min:2',
        ]);

        if ($id) {
            $poll         = Poll::findOrFail($id);
            $notification = 'Poll updated successfully';
        } else {
            $poll         = new Poll();
            $notification = 'Poll added successfully';
        }

        $poll->question = $request->question;
        $poll->options = $request->options;
        $poll->save();

        $notify[] = ['success', $notification];

        return back()->withNotify($notify);
    }
    public function changeStatus($id)
    {
        return Poll::changeStatus($id);
    }
}
