<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\Rj;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;

class ManageEventController extends Controller
{
    public function index()
    {
        $pageTitle = 'All Events';
        $events    = Event::searchable(['name', 'rj:name'])->latest()->with('rj')->paginate(getPaginate());
        $rjs       = Rj::get();
        return view('admin.event', compact('pageTitle', 'rjs', 'events'));
    }

    public function store(Request $request, $id = 0)
    {
        $imageValidation = $id ? 'nullable' : 'required';
        $request->validate([
            'rj_id' => 'required|exists:rjs,id',
            'name'  => 'required|max:255',
            'day'   => 'required|in:saturday,sunday,monday,tuesday,wednesday,thursday,friday',
            'start' => 'required|date_format:H:i|before:end',
            'end'   => 'required|date_format:H:i|after:start',
            'image' => [$imageValidation, 'image', 'max:2048', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
        ]);

        if ($id) {
            $event        = Event::findOrFail($id);
            $notification = 'Event updated successfully';
        } else {
            $event        = new Event();
            $notification = 'Event added successfully';
        }

        if ($request->hasFile('image')) {
            $fileName     = fileUploader($request->image, getFilePath('event'), getFileSize('event'), @$event->image);
            $event->image = $fileName;
        }

        $event->rj_id = $request->rj_id;
        $event->name  = $request->name;
        $event->day   = $request->day;
        $event->start = $request->start;
        $event->end   = $request->end;
        $event->save();

        $notify[] = ['success', $notification];
        return back()->withNotify($notify);
    }

    public function delete($id)
    {
        $event = Event::findOrFail($id);
        $event->delete();

        $notify[] = ['success', 'Event deleted successfully'];
        return back()->withNotify($notify);
    }
}
