<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Archive;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;

class ManageArchiveController extends Controller
{
    protected function archiveData($scope = null)
    {
        $archives = Archive::query();

        if ($scope) {
            $archives = $archives->$scope();
        }

        $archives  = $archives->searchable(['name', 'rj:name'])->latest()->with('rj')->paginate(getPaginate());
        $pageTitle = $this->pageTitle . ' Archives';

        return view('admin.archive', compact('pageTitle', 'archives'));
    }

    public function index()
    {
        $this->pageTitle = 'All';
        return $this->archiveData('');
    }

    public function pending()
    {
        $this->pageTitle = 'Pending';
        return $this->archiveData('pending');
    }

    public function store(Request $request, $id = 0)
    {
        $request->validate([
            'url'  => 'sometimes|url|max:255',
            'file' => ['sometimes', new FileTypeValidate(['mp3', 'mpga', 'wav', 'ogg'])],
        ]);

        $archive = Archive::findOrFail($id);
        $getData = false;

        if ($request->url || $request->file) {
            $getData = true;
        }

        if (!$getData) {
            $notify[] = ['error', 'You must have to provide a file or url'];
            return back()->withNotify($notify);
        }

        if ($request->url) {
            fileManager()->removeFile(getFilePath('archive_file') . '/' . @$archive->file);
            $archive->file = null;
        }

        if ($request->hasFile('file')) {
            $fileName      = fileUploader($request->file, getFilePath('archive_file'), null, @$archive->file);
            $archive->file = $fileName;
            $archive->url  = null;
        }

        $archive->url = $request->url;
        $archive->save();

        $notify[] = ['success', 'Archive events updated successfully'];
        return back()->withNotify($notify);
    }

    public function delete($id)
    {
        $archive = Archive::findOrFail($id);

        if ($archive->file) {
            fileManager()->removeFile(getFilePath('archive_file') . '/' . @$archive->file);
        }

        $archive->delete();

        $notify[] = ['success', 'Archive deleted successfully'];
        return back()->withNotify($notify);
    }
}
