<?php
header("Content-Type:text/css");
function checkhexcolor($color)
{
    return preg_match('/^#[a-f0-9]{6}$/i', $color);
}

$color = '';
$secondColor = '';

if (isset($_GET['color']) and $_GET['color'] != '') {
    $color = "#" . $_GET['color'];
}

if (!$color or !checkhexcolor($color)) {
    $color = "#336699";
}


if (isset($_GET['secondColor']) and $_GET['secondColor'] != '') {
    $secondColor = "#" . $_GET['secondColor'];
}

if (!$secondColor or !checkhexcolor($secondColor)) {
    $secondColor = "#336699";
}


function hexToRgb($hex, $alpha = false)
{
    $hex      = str_replace('#', '', $hex);
    $length   = strlen($hex);
    $rgb['r'] = hexdec($length == 6 ? substr($hex, 0, 2) : ($length == 3 ? str_repeat(substr($hex, 0, 1), 2) : 0));
    $rgb['g'] = hexdec($length == 6 ? substr($hex, 2, 2) : ($length == 3 ? str_repeat(substr($hex, 1, 1), 2) : 0));
    $rgb['b'] = hexdec($length == 6 ? substr($hex, 4, 2) : ($length == 3 ? str_repeat(substr($hex, 2, 1), 2) : 0));
    if ($alpha) {
        $rgb['a'] = $alpha;
    }
    return $rgb;
}


function hexToHsl($hex)
{
    $hex      = str_replace('#', '', $hex);
    $red = hexdec(substr($hex, 0, 2)) / 255;
    $green = hexdec(substr($hex, 2, 2)) / 255;
    $blue = hexdec(substr($hex, 4, 2)) / 255;

    $cmin = min($red, $green, $blue);
    $cmax = max($red, $green, $blue);
    $delta = $cmax - $cmin;

    if ($delta == 0) {
        $hue = 0;
    } elseif ($cmax === $red) {
        $hue = (($green - $blue) / $delta);
    } elseif ($cmax === $green) {
        $hue = ($blue - $red) / $delta + 2;
    } else {
        $hue = ($red - $green) / $delta + 4;
    }

    $hue = round($hue * 60);
    if ($hue < 0) {
        $hue += 360;
    }


    $lightness = (($cmax + $cmin) / 2);
    $saturation = $delta === 0 ? 0 : ($delta / (1 - abs(2 * $lightness - 1)));
    if ($saturation < 0) {
        $saturation += 1;
    }

    $lightness = round($lightness * 100);
    $saturation = round($saturation * 100);

    $hsl['h'] = $hue;
    $hsl['s'] = $saturation;
    $hsl['l'] = $lightness;
    return $hsl;
}


?>

:root{
--main: <?php echo hexToHsl($color)['h']; ?>,
<?php echo hexToHsl($color)['s']; ?>,
<?php echo hexToHsl($color)['l']; ?>;

--base-h: <?php echo hexToHsl($color)['h'];  ?>;
--base-s: <?php echo hexToHsl($color)['s'];  ?>%;
--base-l: <?php echo hexToHsl($color)['l'];  ?>%;
--base-two-h: <?php echo hexToHsl($secondColor)['h']; ?>;
--base-two-s: <?php echo hexToHsl($secondColor)['s']; ?>%;
--base-two-l: <?php echo hexToHsl($secondColor)['l']; ?>%;
}


a:hover, .page-breadcrumb li:first-child::before, .page-breadcrumb li a:hover, .preloader__inner .logo-area .logo-name, .btn-outline--base, .badge--base, .header .main-menu li.menu_has_children:hover>a::before, .header .main-menu li a:hover,
.header .main-menu li a:focus, .header-login-btn:hover i, .contact-item .content p a:hover, .d-widget__icon i, .footer-short-list li a:hover,.header .main-menu li a.active, .header .main-menu li a:hover, .header .main-menu li a:focus,.text--base {
color: <?php echo $color ?>;
}

.text--base, a.text-white:hover {
color: <?php echo $color ?> !important;
}

.audio-player .timeline .progress, .ui-state-highlight,
.ui-widget-content .ui-state-highlight,
.ui-widget-header .ui-state-highlight,.btn--base:hover {
background: <?php echo $color ?>;
}

.custom--accordion .accordion-button:not(.collapsed), .custom--tab .nav-item .nav-link.active, .progress-bar, .video-btn, .video-btn::before,
.video-btn::after, .cursor, .pagination .page-item.active .page-link, .preloader__inner .loading-bar::after, .btn--base, .btn-outline--base:hover, .input-group-text, .header .main-menu li .sub-menu, .header .main-menu li .sub-menu li a::before, .header-login-btn, .hero-slider .slick-dots li.slick-active button, .view-details-btn, .schedule-card__thumb .schedule-btn, .audio-player.style--two .play-container, .date-select-form .date-select-btn, .rj-single .thumb .social-links li a, .resume-card .icon, .contact-item .ico, .d-widget:hover .d-widget__amount::after, .profile-thumb .avatar-edit label, .qr-code-copy-form input[type="submit"], .custom--file-upload::before, .social-links-list li a, .scroll-to-top, .scroll-to-top, .custom-radio label::after, .contact-item .icon {
background-color: <?php echo $color ?> !important;
}

.bg--base, .header.menu-fixed .header__bottom , .footer::before,.event_audio.style--two .event_container {
background-color: <?php echo $color ?> !important;
}

.custom--tab .nav-item .nav-link.active, .input-group-text, .ui-state-highlight,
.ui-widget-content .ui-state-highlight,
.ui-widget-header .ui-state-highlight, .d-widget:hover, .deposit-card:hover, .custom-radio input[type=radio]:checked~label::before {
border-color: <?php echo $color ?>;
}

.cursor-follower, .btn-outline--base, .badge--base, .form--control, .header-login-btn {
border: 1px solid <?php echo $color ?>;
}

.border--base, .form--control:focus {
border: 1px solid <?php echo $color ?> !important;
}

.header .main-menu li .sub-menu, .play-container::after, .deposit-preview-card {
border: 2px solid <?php echo $color ?>;
}

.header.menu-fixed .header__bottom , .footer::before,.play-container::after{
background-color: <?php echo $secondColor ?> !important;
}
.poll-open-btn {
box-shadow: 5px 0 5px <?php echo $color ?>73;
}
.event-card {
border-color: <?php echo $color ?>;
}
.controls .right,.equalizer-item,.schedule-card__thumb::before{
background-image:-webkit-linear-gradient(7deg, <?php echo $color ?> 0%,<?php echo $secondColor ?> 100%)
}
.rj-single .thumb::after {
background: linear-gradient(to bottom, <?php echo $color ?>26, <?php echo $color ?>);
}